package ru.yandex.direct.ess.logicobjects.moderation.contentpromotion;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.logicobjects.moderation.BaseModerationObject;

public final class ContentPromotionAccessibilityLogicObject extends BaseModerationObject {

    @JsonProperty("content_promotion_id")
    private final Long contentPromotionId;

    @JsonProperty("is_inaccessible")
    private final Long isInaccessible;

    @JsonCreator
    public ContentPromotionAccessibilityLogicObject(
            @JsonProperty("ess_tag") String essTag,
            @JsonProperty("event_time") Long eventTime,
            @JsonProperty("content_promotion_id") Long contentPromotionId,
            @JsonProperty("is_inaccessible") Long isInaccessible,
            @JsonProperty("was_copied") Boolean wasCopied
    ) {
        super(essTag, eventTime, wasCopied);
        this.contentPromotionId = contentPromotionId;
        this.isInaccessible = isInaccessible;
    }

    public Long getContentPromotionId() {
        return contentPromotionId;
    }

    public Long getIsInaccessible() {
        return isInaccessible;
    }

    @Override
    public Long getObjectId() {
        return contentPromotionId;
    }

    @Override
    public String toString() {
        return "ContentPromotionAccessibilityLogicObject{" +
                "contentPromotionId=" + contentPromotionId +
                ", isInaccessible=" + isInaccessible +
                "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContentPromotionAccessibilityLogicObject that = (ContentPromotionAccessibilityLogicObject) o;
        return Objects.equals(contentPromotionId, that.contentPromotionId)
                && Objects.equals(isInaccessible,
                that.isInaccessible);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), contentPromotionId, isInaccessible);
    }
}
