package ru.yandex.direct.ess.logicobjects.moderation.mobilecontenticon;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.logicobjects.moderation.BaseModerationObject;

public class MobileContentIconModerationEventsObject extends BaseModerationObject {
    @JsonProperty("mobile_content_id")
    private final Long mobileContentId;

    public MobileContentIconModerationEventsObject(
            @JsonProperty("ess_tag") String essTag,
            @JsonProperty("event_time") Long eventTime,
            @JsonProperty("was_copied") Boolean wasCopied,
            @JsonProperty("mobile_content_id") Long mobileContentId) {
        super(essTag, eventTime, wasCopied);
        this.mobileContentId = mobileContentId;
    }

    @Override
    public Long getObjectId() {
        return mobileContentId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MobileContentIconModerationEventsObject that = (MobileContentIconModerationEventsObject) o;
        return Objects.equals(mobileContentId, that.mobileContentId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), mobileContentId);
    }

    @Override
    public String toString() {
        return "MobileContentIconModerationEventsObject{" +
                "mobileContentId=" + mobileContentId +
                '}' + super.toString();
    }
}
