package ru.yandex.direct.ess.logicobjects.moderation.special;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.ess.common.circuits.moderation.ModerationArchivingObjectType;
import ru.yandex.direct.ess.logicobjects.moderation.AbstractModerationEvent;

public class ModerationArchivingEvent extends AbstractModerationEvent {

    @JsonProperty("campaign_id")
    private final Long campaignId;

    @JsonProperty("adgroup_id")
    private final Long adGroupId;

    @JsonProperty("banner_id")
    private final Long bannerId;

    @JsonProperty("banner_type")
    private final BannersBannerType bannersBannerType;

    @JsonProperty("type")
    private final ModerationArchivingObjectType type;

    @JsonCreator
    public ModerationArchivingEvent(
            @JsonProperty("ess_tag") String essTag,
            @JsonProperty("event_time") Long eventTime,
            @JsonProperty("campaign_id") Long campaignId,
            @JsonProperty("adgroup_id") Long adgroupId,
            @JsonProperty("banner_id") Long bannerId,
            @JsonProperty("banner_type") BannersBannerType bannerType,
            @JsonProperty("type") ModerationArchivingObjectType type) {
        super(essTag, eventTime);
        this.campaignId = campaignId;
        this.adGroupId = adgroupId;
        this.bannerId = bannerId;
        this.bannersBannerType = bannerType;
        this.type = type;
    }

    public static ModerationArchivingEvent bannerArchivingEvent(String essTag,
                                                                Long eventTime,
                                                                Long campaignId,
                                                                Long adGroupId,
                                                                Long bannerId,
                                                                BannersBannerType bannerType) {
        return new ModerationArchivingEvent(essTag, eventTime, campaignId, adGroupId, bannerId, bannerType,
                ModerationArchivingObjectType.BANNER);
    }

    public static ModerationArchivingEvent campaignArchivingEvent(String essTag,
                                                                  Long eventTime,
                                                                  Long campaignId) {
        return new ModerationArchivingEvent(essTag, eventTime, campaignId, null, null, null,
                ModerationArchivingObjectType.CAMPAIGN);
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public BannersBannerType getBannersBannerType() {
        return bannersBannerType;
    }

    public ModerationArchivingObjectType getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModerationArchivingEvent that = (ModerationArchivingEvent) o;
        return Objects.equals(campaignId, that.campaignId) && Objects.equals(adGroupId, that.adGroupId)
                && Objects.equals(bannerId, that.bannerId) && bannersBannerType == that.bannersBannerType && type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), campaignId, adGroupId, bannerId, bannersBannerType, type);
    }

    @Override
    public String toString() {
        return "ModerationArchivingEvent{" +
                "campaignId=" + campaignId +
                ", adGroupId=" + adGroupId +
                ", bannerId=" + bannerId +
                ", bannersBannerType=" + bannersBannerType +
                ", type=" + type +
                '}';
    }
}
