package ru.yandex.direct.ess.logicobjects.moderation.special;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.common.circuits.moderation.ModerationDeletionObjectType;
import ru.yandex.direct.ess.logicobjects.moderation.AbstractModerationEvent;

/**
 * Описывает удаление какого-либо модерируемого объекта.
 */
public class ModerationDeletionEvent extends AbstractModerationEvent {

    @JsonProperty("id")
    private final Long id;

    @JsonProperty("type")
    private final ModerationDeletionObjectType type;

    @JsonCreator
    public ModerationDeletionEvent(
            @JsonProperty("ess_tag") String essTag,
            @JsonProperty("event_time") Long eventTime,
            @JsonProperty("id") Long id,
            @JsonProperty("type") ModerationDeletionObjectType type) {
        super(essTag, eventTime);
        this.id = id;
        this.type = type;
    }

    public Long getId() {
        return id;
    }

    public ModerationDeletionObjectType getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModerationDeletionEvent that = (ModerationDeletionEvent) o;
        return Objects.equals(id, that.id) && type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), id, type);
    }

    @Override
    public String toString() {
        return "ModerationDeletionEvent{" +
                "id=" + id +
                ", type=" + type +
                '}' + super.toString();
    }
}
