package ru.yandex.direct.ess.logicobjects.moderation.special;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.logicobjects.moderation.AbstractModerationEvent;

/**
 * Описывает изменение флагов баннера
 */
public class ModerationFlagsEvent extends AbstractModerationEvent {

    @JsonProperty("campaign_id")
    private final Long campaignId;

    @JsonProperty("adgroup_id")
    private final Long adGroupId;

    @JsonProperty("banner_id")
    private final Long bannerId;

    @JsonProperty("flags")
    private final String flags;

    @JsonCreator
    public ModerationFlagsEvent(
            @JsonProperty("ess_tag") String essTag,
            @JsonProperty("event_time") Long eventTime,
            @JsonProperty("campaign_id") Long campaignId,
            @JsonProperty("adgroup_id") Long adGroupId,
            @JsonProperty("banner_id") Long bannerId,
            @JsonProperty("flags") String flags) {
        super(essTag, eventTime);
        this.campaignId = campaignId;
        this.adGroupId = adGroupId;
        this.bannerId = bannerId;
        this.flags = flags;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public String getFlags() {
        return flags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModerationFlagsEvent that = (ModerationFlagsEvent) o;
        return Objects.equals(campaignId, that.campaignId) && Objects.equals(adGroupId, that.adGroupId) && Objects.equals(bannerId, that.bannerId) && Objects.equals(flags, that.flags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), campaignId, adGroupId, bannerId, flags);
    }

    @Override
    public String toString() {
        return "ModerationFlagsEvent{" +
                "campaignId=" + campaignId +
                ", adGroupId=" + adGroupId +
                ", bannerId=" + bannerId +
                ", flags='" + flags + '\'' +
                '}' + super.toString();
    }
}
