package ru.yandex.direct.ess.logicobjects.moderation.turbolandings;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.logicobjects.moderation.BaseModerationObject;
import ru.yandex.direct.ess.logicobjects.moderation.ModerationEventsObjectWithBannerId;

public class TurbolandingsModerationEventsObject extends BaseModerationObject implements ModerationEventsObjectWithBannerId {

    @JsonProperty("banner_id")
    private final long bannerId;

    @JsonCreator
    public TurbolandingsModerationEventsObject(
            @JsonProperty("ess_tag") String essTag,
            @JsonProperty("event_time") Long eventTime,
            @JsonProperty("banner_id") long bannerId,
            @JsonProperty("was_copied") Boolean wasCopied) {
        super(essTag, eventTime, wasCopied);
        this.bannerId = bannerId;
    }

    public Long getBannerId() {
        return bannerId;
    }

    @Override
    public Long getObjectId() {
        return bannerId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        if (!super.equals(o)) {
            return false;
        }
        TurbolandingsModerationEventsObject that = (TurbolandingsModerationEventsObject) o;
        return bannerId == that.bannerId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), bannerId);
    }
}
