package ru.yandex.direct.ess.logicobjects.mysql2grut

import com.fasterxml.jackson.annotation.JsonProperty
import ru.yandex.direct.ess.common.models.BaseLogicObject

data class Mysql2GrutReplicationObject(
    @JsonProperty("client_id")
    val clientId: Long? = null,
    @JsonProperty("campaign_id")
    val campaignId: Long? = null,
    @JsonProperty("order_id")
    val orderId: Long? = null,
    @JsonProperty("adgroup_id")
    val adGroupId: Long? = null,
    @JsonProperty("minus_phrase_id")
    val minusPhraseId: Long? = null,
    @JsonProperty("mobile_content_id")
    val mobileContentId: Long? = null,
    @JsonProperty("vcard_id")
    val vcardId: Long? = null,
    @JsonProperty("vcard_address_id")
    val vcardAddressId: Long? = null,
    @JsonProperty("creative_id")
    val creativeId: Long? = null,

    @JsonProperty("biddable_show_condition_id")
    val biddableShowConditionId: Long? = null,
    @JsonProperty("biddable_show_condition_type")
    val biddableShowConditionType: BiddableShowConditionChangeType? = null,

    @JsonProperty("client_autooverdraft_limit_changed")
    val clientAutoOverdraftLimitChanged: Long? = null,
    @param:JsonProperty("is_deleted")
    @get:JsonProperty("is_deleted")
    val isDeleted: Boolean = false,
    @JsonProperty("banner_id")
    val bannerId: Long? = null,
    @JsonProperty("retargeting_condition_id")
    val retargetingConditionId: Long? = null,

    @JsonProperty("bid_modifier_id")
    val bidModifierId: Long? = null,
    @JsonProperty("bid_modifier_table_type")
    val bidModifierTableType: BidModifierTableType? = null,
    // Отдельное свойство с идентификатором корректировки для заполнения связей группы-корректировки и
    // кампании-корректировки, чтобы не выполнять лишние операции на update корректировок
    @JsonProperty("bid_modifier_id_for_relation")
    val bidModifierIdForRelation: Long? = null,
    @JsonProperty("strategy_id")
    val strategyId: Long? = null,
    @JsonProperty("price_package_id")
    val pricePackageId: Long? = null,
    ) : BaseLogicObject()

enum class BidModifierTableType {
    PARENT, // HIERARCHICAL_MULTIPLIER
    BANNER_TYPE,
    DEMOGRAPHY,
    EXPRESSION,
    INVENTORY,
    MOBILE,
    RETARGETING,
    AB_SEGMENT,
    TABLET,
    TRAFARET_POSITION,
    WEATHER,
    GEO,
}

enum class BiddableShowConditionChangeType {
    KEYWORD,
    HREF_PARAM, // Используется в KEYWORD и RELEVANCE_MATCH
    RELEVANCE_MATCH,
    OFFER_RETARGETING,
    DYNAMIC,
    DYNAMIC_CONDITION, // Используется в DYNAMIC
    PERFORMANCE,
    RETARGETING,
}

