package ru.yandex.direct.ess.logicobjects.promocodescheckcampaignchanges;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;

import static java.util.function.Function.identity;

public enum IdTypeEnum {
    CID("cid"),
    PID("pid");

    private String idTypeName;

    IdTypeEnum(String idTypeName) {
        this.idTypeName = idTypeName;
    }

    private static final Map<String, IdTypeEnum> VALUES_MAP = ImmutableMap.copyOf(
            Arrays.stream(IdTypeEnum.values())
                    .collect(Collectors.toMap(
                            idType -> idType.idTypeName,
                            identity()
                    )));

    @JsonCreator
    public static IdTypeEnum fromString(String val) {
        return VALUES_MAP.get(val);
    }

    @JsonValue
    public String getIdTypeName() {
        return idTypeName;
    }

    @Override
    public String toString() {
        return idTypeName;
    }


}
