package ru.yandex.direct.ess.logicobjects.promocodescheckcampaignchanges;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.common.models.BaseLogicObject;

public class PromocodesCheckCampaignChangesObject extends BaseLogicObject {

    /* Это либо cid, либо pid (зависит от idType) */
    @JsonProperty("id")
    private Long id;

    @JsonProperty("id_type")
    private IdTypeEnum idType;


    @JsonCreator
    public PromocodesCheckCampaignChangesObject(
            @JsonProperty("id") Long id,
            @JsonProperty("id_type") IdTypeEnum idType
    ) {
        this.id = id;
        this.idType = idType;
    }

    public Long getId() {
        return id;
    }

    public IdTypeEnum getIdType() {
        return idType;
    }

    @Override
    public String toString() {
        return "PromocodesCheckCampaignChangesObject{"
                + "id=" + id
                + ", idType=" + idType
                + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PromocodesCheckCampaignChangesObject that = (PromocodesCheckCampaignChangesObject) o;
        return Objects.equals(id, that.id) &&
                idType == that.idType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, idType);
    }
}
