package ru.yandex.direct.ess.logicobjects.recomtracer;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.jooq.Named;

public class AdditionalColumns {

    @JsonProperty("columns_to_values")
    private Map<String, Object> columnsToValues = new HashMap<>();

    public void add(Named column, Object value) {
        columnsToValues.put(column.getName(), value);
    }

    public boolean contains(Named column) {
        return columnsToValues.containsKey(column.getName());
    }

    @SuppressWarnings("unchecked")
    public <R> R get(Named column) {
        return (R) columnsToValues.get(column.getName());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AdditionalColumns that = (AdditionalColumns) o;
        return Objects.equals(columnsToValues, that.columnsToValues);
    }

    @Override
    public int hashCode() {
        return Objects.hash(columnsToValues);
    }

    @Override
    public String toString() {
        return "AdditionalColumns{" +
                "columnsToValues=" + columnsToValues +
                '}';
    }
}
