package ru.yandex.direct.ess.logicobjects.recomtracer;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;

import static java.util.function.Function.identity;

public enum RecommendationKeyIdentifier {
    BID("bid"),
    PID("pid"),
    CID("cid"),
    CLIENT_ID("ClientId");

    private String name;

    RecommendationKeyIdentifier(String name) {
        this.name = name;
    }

    private static final Map<String, RecommendationKeyIdentifier> VALUES_MAP = ImmutableMap.copyOf(
            Arrays.stream(RecommendationKeyIdentifier.values())
                    .collect(Collectors.toMap(
                            identifier -> identifier.name,
                            identity()
                    )));

    @JsonCreator
    public static RecommendationKeyIdentifier fromString(String val) {
        return VALUES_MAP.get(val);
    }

    @JsonValue
    public String getRecomendationIdentifierName() {
        return name;
    }

    @Override
    public String toString() {
        return name;
    }
}
