package ru.yandex.direct.ess.fulltest;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.ApplicationContext;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.router.models.rule.AbstractRule;
import ru.yandex.direct.ess.router.models.rule.EssRule;
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessorNotScheduled;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;

import static com.google.common.base.Preconditions.checkNotNull;

@ParametersAreNonnullByDefault
public class EssChainUtils {
    private EssChainUtils() {
    }

    public static Supplier<BaseLogicProcessorNotScheduled<BaseLogicObject>> getBaseLogicProcessorSupplier(
            ApplicationContext applicationContext, Class<? extends BaseEssConfig> configClass) {
        String[] beanNamesForAnnotation = applicationContext.getBeanNamesForAnnotation(EssLogicProcessor.class);
        Optional<String> beanNameForConfig = Arrays.stream(beanNamesForAnnotation)
                .filter(name -> {
                    var annotationOnBean = checkNotNull(
                            applicationContext.findAnnotationOnBean(name, EssLogicProcessor.class));
                    return annotationOnBean.value().isAssignableFrom(configClass);
                })
                .findFirst();
        String beanName = beanNameForConfig.orElseThrow();
        return () -> applicationContext.getBean(beanName, BaseLogicProcessorNotScheduled.class);
    }

    @Nullable
    public static AbstractRule<BaseLogicObject> getRule(ApplicationContext applicationContext,
                                                        Class<? extends BaseEssConfig> configClass) {
        String[] beanNamesForAnnotation = applicationContext.getBeanNamesForAnnotation(EssRule.class);
        Optional<String> beanName = Arrays.stream(beanNamesForAnnotation)
                .filter(name -> {
                    var annotationOnBean = checkNotNull(
                            applicationContext.findAnnotationOnBean(name, EssRule.class));
                    return annotationOnBean.value().isAssignableFrom(configClass);
                })
                .findFirst();

        if (beanName.isPresent()) {
            return applicationContext.getBean(beanName.get(), AbstractRule.class);
        } else {
            return null;
        }
    }

    public static Supplier<BaseLogicProcessorNotScheduled<BaseLogicObject>> getBaseLogicProcessorSupplierForRule(
            ApplicationContext applicationContext, Class<? extends AbstractRule> ruleClass) {
        Class<? extends BaseEssConfig> configClass = ruleClass.getAnnotation(EssRule.class).value();
        return getBaseLogicProcessorSupplier(applicationContext, configClass);
    }

}
