package ru.yandex.direct.ess.fulltest.configuration.comandline;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import one.util.streamex.StreamEx;

import ru.yandex.direct.ess.common.models.EssGroup;
import ru.yandex.direct.ess.router.configuration.commandline.AppParams;

import static com.google.common.base.Preconditions.checkArgument;

@ParametersAreNonnullByDefault
public class DebugParams {
    @ParametersDelegate
    public AppParams routerParams = new AppParams();

    @Parameter(
            names = {"--ess-config"},
            variableArity = true,
            description = "List of ess configs"
    )
    public List<String> essConfigClassNames = new ArrayList<>();

    @Parameter(
            names = {"--ess-group"},
            description = "Ess group name for selecting rules and logic-processors to be run."
    )
    public String essGroup;

    @Parameter(
            names = {"-t", "--working-time"},
            description = "Application working time in sec. Default - 60 sec."
    )
    public int workingTimeSec = 60;

    public void validate() {
        routerParams.validate();

        if (essConfigClassNames.isEmpty()) {
            checkArgument(essGroup != null && !essGroup.isBlank(),
                    "You must set at least one of '--ess-config' or '--ess-group'.");

            List<String> existingEssGroupNames = StreamEx.of(EssGroup.values())
                    .map(group -> group.name().toLowerCase())
                    .toList();
            checkArgument(existingEssGroupNames.contains(essGroup.toLowerCase()),
                    "Unknown ess group: {}", essGroup);
        }
    }
}
