package ru.yandex.direct.logicprocessor.common;

import ru.yandex.direct.env.TypicalEnvironment;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.HourglassDaemon;

/**
 * Base class for custom logic processors.
 * It is scheduled on all environments.
 * Each inheritors should define the annotation {@link EssLogicProcessor}
 * , call super constructor with autowired EssLogicProcessorContext
 * and define a void method process(List<BaseLogicObject> logicObjects)
 */
@HourglassDaemon(runPeriod = 0)
@Hourglass(periodInSeconds = 0, needSchedule = TypicalEnvironment.class)
public abstract class BaseLogicProcessor<T extends BaseLogicObject> extends BaseLogicProcessorNotScheduled<T> {
    public BaseLogicProcessor(EssLogicProcessorContext essLogicProcessorContext) {
        super(essLogicProcessorContext);
    }
}
