package ru.yandex.direct.logicprocessor.common;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.ess.common.models.BaseEssConfig;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

/**
 * Аннотация, которой помечаются пользовательские logic-processor'ы
 * Параметр - пользовательский конфиг ess, наследуемй от {@link BaseEssConfig} класс
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Component
@Scope(SCOPE_PROTOTYPE)
public @interface EssLogicProcessor {
    Class<? extends BaseEssConfig> value();
}
