package ru.yandex.direct.logicprocessor.common;

import java.time.Duration;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcProperty;
import ru.yandex.direct.ess.common.logbroker.LogbrokerClientFactoryFacade;
import ru.yandex.direct.ess.common.utils.EssCommonUtils;

import static ru.yandex.direct.common.db.PpcPropertyNames.DISABLED_ESS_LOGIC_PROCESSORS;
import static ru.yandex.direct.ess.common.configuration.EssCommonConfiguration.ESS_LOGBROKER_CLIENT_FACTORY_BEAN_NAME;

@Component
public class EssLogicProcessorContext {

    private final LogicProcessorLogbrokerCommonConfig logicProcessorLogbrokerCommonConfig;
    private final LogbrokerClientFactoryFacade logbrokerClientFactory;
    private final EssCommonUtils essCommonUtils;
    private final EssLogicObjectsBlacklist blacklist;
    private final PpcProperty<Set<String>> disabledLogicProcessorsProp;

    @Autowired
    public EssLogicProcessorContext(
            LogicProcessorLogbrokerCommonConfig logicProcessorLogbrokerCommonConfig,
            @Qualifier(ESS_LOGBROKER_CLIENT_FACTORY_BEAN_NAME) LogbrokerClientFactoryFacade logbrokerClientFactory,
            EssCommonUtils essCommonUtils,
            PpcPropertiesSupport ppcPropertiesSupport,
            @Value("${ess.logic_processors.ppc_property_expire_sec}") int ppcPropertyExpireSec,
            EssLogicObjectsBlacklist blacklist)
    {
        this.logicProcessorLogbrokerCommonConfig = logicProcessorLogbrokerCommonConfig;
        this.logbrokerClientFactory = logbrokerClientFactory;
        this.essCommonUtils = essCommonUtils;
        this.disabledLogicProcessorsProp = ppcPropertiesSupport.get(
                DISABLED_ESS_LOGIC_PROCESSORS,
                Duration.ofSeconds(ppcPropertyExpireSec));
        this.blacklist = blacklist;
    }

    LogicProcessorLogbrokerCommonConfig getLogicProcessorLogbrokerCommonConfig() {
        return logicProcessorLogbrokerCommonConfig;
    }

    LogbrokerClientFactoryFacade getLogbrokerClientFactory() {
        return logbrokerClientFactory;
    }

    EssCommonUtils getEssCommonUtils() {
        return essCommonUtils;
    }

    public EssLogicObjectsBlacklist getBlacklist() {
        return blacklist;
    }

    public PpcProperty<Set<String>> getDisabledLogicProcessorsProp() {
        return disabledLogicProcessorsProp;
    }
}
