package ru.yandex.direct.logicprocessor.common;

import com.google.common.base.Preconditions;

public class LogicProcessorLogbrokerCommonConfig {
    private final String host;
    private final String consumerName;
    private final long readDataTimeoutSec;
    private final long initTimeoutSec;
    private final int retries;
    private final int readBufferSize;
    private final int maxCount;

    private LogicProcessorLogbrokerCommonConfig(String host, String consumerName, long readDataTimeoutSec,
            long initTimeoutSec, int retryCount, int readBufferSize, int maxCount)
    {
        this.host = host;
        this.consumerName = consumerName;
        this.readDataTimeoutSec = readDataTimeoutSec;
        this.initTimeoutSec = initTimeoutSec;
        this.retries = retryCount;
        this.readBufferSize = readBufferSize;
        this.maxCount = maxCount;
    }


    public String getHost() {
        return host;
    }

    public String getConsumerName() {
        return consumerName;
    }

    public long getReadDataTimeoutSec() {
        return readDataTimeoutSec;
    }

    public long getInitTimeoutSec() {
        return initTimeoutSec;
    }

    public int getRetries() {
        return retries;
    }

    public int getReadBufferSize() {
        return readBufferSize;
    }

    public int getMaxCount() {
        return maxCount;
    }

    public static class Builder {
        private String host;
        private String consumerName;
        private Long readDataTimeoutSec;
        private Long initTimeoutSec;
        private Integer retries;
        private Integer readBufferSize;
        private Integer maxCount;

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setConsumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public Builder setReadDataTimeoutSec(long readDataTimeoutSec) {
            this.readDataTimeoutSec = readDataTimeoutSec;
            return this;
        }

        public Builder setInitTimeoutSec(long initTimeoutSec) {
            this.initTimeoutSec = initTimeoutSec;
            return this;
        }

        public Builder setRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public Builder setReadBufferSize(int readBufferSize) {
            this.readBufferSize = readBufferSize;
            return this;
        }

        public Builder setMaxCount(int maxCount) {
            this.maxCount = maxCount;
            return this;
        }


        public LogicProcessorLogbrokerCommonConfig build() {
            Preconditions.checkState(host != null, "forgotten host");
            Preconditions.checkState(consumerName != null, "forgotten consumerName");
            Preconditions.checkState(readDataTimeoutSec != null, "forgotten timeout");
            Preconditions.checkState(initTimeoutSec != null, "forgotten initTimeout");
            Preconditions.checkState(retries != null, "forgotten retries");
            Preconditions.checkState(readBufferSize != null, "forgotten readBufferSize");
            Preconditions.checkState(maxCount != null, "forgotten maxCount");
            return new LogicProcessorLogbrokerCommonConfig(host, consumerName, readDataTimeoutSec,
                    initTimeoutSec, retries, readBufferSize, maxCount);
        }
    }
}
