package ru.yandex.direct.logicprocessor.common;

import java.util.List;

import ru.yandex.direct.ess.common.logbroker.LogbrokerConsumerProperties;

public class LogicProcessorLogbrokerProperties implements LogbrokerConsumerProperties {
    private final String host;
    private final String consumerName;
    private final long readDataTimeoutSec;
    private final long initTimeoutSec;
    private final String readTopic;
    private final List<Integer> groups;
    private final int readBufferSize;
    private final int maxCount;

    public LogicProcessorLogbrokerProperties(LogicProcessorLogbrokerCommonConfig commonConfig, String readTopic,
            List<Integer> groups)
    {
        this.host = commonConfig.getHost();
        this.consumerName = commonConfig.getConsumerName();
        this.readDataTimeoutSec = commonConfig.getReadDataTimeoutSec();
        this.initTimeoutSec = commonConfig.getInitTimeoutSec();
        this.readTopic = readTopic;
        this.groups = groups;
        this.readBufferSize = commonConfig.getReadBufferSize();
        this.maxCount = commonConfig.getMaxCount();
    }

    @Override
    public String getHost() {
        return host;
    }

    @Override
    public String getReadTopic() {
        return readTopic;
    }

    @Override
    public List<Integer> getGroups() {
        return groups;
    }

    @Override
    public long getReadDataTimeoutSec() {
        return readDataTimeoutSec;
    }

    @Override
    public long getInitTimeoutSec() {
        return initTimeoutSec;
    }

    @Override
    public String getConsumerName() {
        return consumerName;
    }

    @Override
    public int getMaxCount() {
        return maxCount;
    }

    @Override
    public int getReadBufferSize() {
        return readBufferSize;
    }
}
