package ru.yandex.direct.logicprocessor.processors.aggregatedstatuses;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.aggregatedstatuses.AggregatedStatusObjectType;
import ru.yandex.direct.core.entity.aggregatedstatus.model.AggregatedStatusQueueEntityType;
import ru.yandex.direct.core.entity.aggregatedstatus.model.AggregatedStatusResyncQueueEntity;
import ru.yandex.direct.ess.logicobjects.aggregatedstatuses.AggregatedStatusEventObject;

import static ru.yandex.direct.utils.FunctionalUtils.filterAndMapList;

@ParametersAreNonnullByDefault
public class AggregatedStatusEventObjectConverter {

    public static List<AggregatedStatusEventObject> getEventObjectsFromResyncQueueEntities(
            List<AggregatedStatusResyncQueueEntity> resyncQueueEntities) {
        return filterAndMapList(resyncQueueEntities,
                entity -> AggregatedStatusQueueEntityType.UNKNOWN != entity.getType(),
                AggregatedStatusEventObjectConverter::toAggregatedStatusEventObject);
    }

    public static AggregatedStatusEventObject toAggregatedStatusEventObject(AggregatedStatusResyncQueueEntity entity) {
        return new AggregatedStatusEventObject(toType(entity.getType()), entity.getEntityId(), null, null, false);
    }

    @Nullable
    private static AggregatedStatusObjectType toType(AggregatedStatusQueueEntityType type) {
        switch (type) {
            case BANNER:
                return AggregatedStatusObjectType.AD;
            case ADGROUP:
                return AggregatedStatusObjectType.ADGROUP;
            case RETARGETING:
                return AggregatedStatusObjectType.RETARGETING;
            case KEYWORD:
                return AggregatedStatusObjectType.KEYWORD;
            case CAMPAIGN:
                return AggregatedStatusObjectType.CAMPAIGN;
        }

        return null;
    }


}
