package ru.yandex.direct.logicprocessor.processors.brandliftrecalc;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.brandliftrecalc.BrandLiftRecalcConfig;
import ru.yandex.direct.ess.logicobjects.brandliftrecalc.BrandLiftRecalcObject;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;
import ru.yandex.direct.tracing.Trace;
import ru.yandex.direct.tracing.TraceProfile;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_1;
import static ru.yandex.direct.juggler.check.model.NotificationRecipient.LOGIN_EBOGUSLAVSKAYA;

@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        notifications = {
                @OnChangeNotification(recipient = LOGIN_EBOGUSLAVSKAYA,
                        status = {JugglerStatus.OK, JugglerStatus.CRIT},
                        method = NotificationMethod.TELEGRAM),
        },
        tags = {DIRECT_PRIORITY_1})
@EssLogicProcessor(BrandLiftRecalcConfig.class)
public class BrandLiftRecalcProcessor  extends BaseLogicProcessor<BrandLiftRecalcObject> {
    private final BrandLiftRecalcService recalcService;

    @Autowired
    public BrandLiftRecalcProcessor(EssLogicProcessorContext essLogicProcessorContext,
                                    BrandLiftRecalcService recalcService) {
        super(essLogicProcessorContext);
        this.recalcService = recalcService;
    }

    @Override
    public void process(List<BrandLiftRecalcObject> objects) {
        int shard = getShard();
        try (TraceProfile profile = Trace.current().profile("brand_lift_recalc")) {
            recalcService.processRecalc(shard, objects);
        }
    }
}
