package ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.common

import ru.yandex.direct.core.entity.adgroup.model.AdGroup
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPlacementTypes
import ru.yandex.direct.core.entity.campaign.model.PlacementType

val defaultTargetTagsByAdGroupType = mapOf(
    AdGroupType.CPM_GEOPRODUCT to listOf("app-metro"),
    AdGroupType.CPM_YNDX_FRONTPAGE to listOf("portal-trusted"),
    AdGroupType.CONTENT_PROMOTION_VIDEO to listOf("content-promotion-video"),
    AdGroupType.CONTENT_PROMOTION to listOf("content-promotion-collection"),
)

fun getTargetTags(adgroup: AdGroup, campaign: CampaignWithPlacementTypes? = null): List<String>? {
    return sequence<String> {
        if (adgroup.targetTags.isNullOrEmpty()) {
            yieldAll(defaultTargetTagsByAdGroupType.getOrDefault(adgroup.type, emptyList()))
        } else {
            yieldAll(adgroup.targetTags)
        }

        if (campaign?.placementTypes == setOf(PlacementType.ADV_GALLERY)) {
            yield("bko-only")
        }
    }.toList().takeIf { it.isNotEmpty() }
}
