package ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.ess.config.bsexport.adgroup.BsExportAdGroupConfig
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.juggler.JugglerStatus
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.JugglerChecks
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_0
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessor
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext

@JugglerChecks(
    JugglerCheck(ttl = JugglerCheck.Duration(minutes = 5), needCheck = ProductionOnly::class,
        tags = [DIRECT_PRIORITY_0],
        notifications = [
            OnChangeNotification(
                recipient = [NotificationRecipient.CHAT_DIRECT_BS_TRANSPORT_YT_MONITORING],
                status = [JugglerStatus.OK, JugglerStatus.CRIT],
                method = [NotificationMethod.TELEGRAM])
        ])
)
@EssLogicProcessor(BsExportAdGroupConfig::class)
class BsExportAdGroupProcessor(
    essLogicProcessorContext: EssLogicProcessorContext,
    private val adGroupService: BsExportAdGroupService,
) : BaseLogicProcessor<BsExportAdGroupObject>(essLogicProcessorContext) {

    override fun process(logicObjects: List<BsExportAdGroupObject>) {
        adGroupService.processAdGroups(shard, logicObjects)
    }
}
