package ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.handler

import org.slf4j.LoggerFactory
import ru.yandex.adv.direct.adgroup.AdGroup
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.AdGroupResource

abstract class AdGroupBaseHandler<R>() {
    companion object {
        private val logger = LoggerFactory.getLogger(AdGroupBaseHandler::class.java)
    }

    open fun getAdGroupIdsToLoad(shard: Int, objects: Collection<BsExportAdGroupObject>): List<Long> {
        return objects.map { it.adGroupId!! }
    }

    abstract fun resourceType(): AdGroupResourceType
    abstract fun loadResources(shard: Int, adGroups: Collection<ru.yandex.direct.core.entity.adgroup.model.AdGroup>):
        List<AdGroupResource<R>>

    abstract fun fillExportObject(resource: R, builder: AdGroup.Builder)

    fun handle(shard: Int, adGroupIdToBuilderMap: Map<Long, AdGroupWithBuilder>) {
        if (adGroupIdToBuilderMap.isEmpty()) return

        val resources = try {
            loadResources(shard, adGroupIdToBuilderMap.values.map { it.adGroup })
        } catch (e: Exception) {
            logger.error("AdGroups processing failed for adgroup ids ${adGroupIdToBuilderMap.keys}", e)
            throw e
        }
        if (resources.isEmpty()) return

        resources
            .forEach { res: AdGroupResource<R> ->
                val builder = adGroupIdToBuilderMap[res.adGroupId]
                builder!!
                    .also {
                        fillExportObject(res.resource, it.protoBuilder)
                    }
            }
    }
}

data class AdGroupWithBuilder(
    val adGroup: ru.yandex.direct.core.entity.adgroup.model.AdGroup,
    val protoBuilder: AdGroup.Builder
)
