package ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.handler

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject


data class AdGroupIdWithCampaignId(
    val adGroupId: Long,
    val campaignId: Long
)

@Component
class AdGroupDeleteHandler(
    private val adGroupRepository: AdGroupRepository,
) {

    fun getDeletedAdGroups(shard: Int, objects: List<BsExportAdGroupObject>): List<AdGroupIdWithCampaignId> {
        val adGroupIds = objects.map { it.adGroupId }
        val existingAdGroups = adGroupRepository.getAdGroups(shard, adGroupIds).map { it.id }.toSet()
        val toDelete = objects
            .filter { it.adGroupId !in existingAdGroups }
        return toDelete
            .filter { it.campaignId != null }
            .map { AdGroupIdWithCampaignId(it.adGroupId!!, it.campaignId!!) }
            .toList()
    }
}
