package ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.adgroup.AdGroup
import ru.yandex.adv.direct.adgroup.OptionalInternalLevel
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.core.entity.adgroup.model.InternalAdGroup
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.AdGroupResource
import ru.yandex.direct.logicprocessor.processors.bsexport.common.createRfOptions
import java.time.Duration

data class AdGroupInternalFields(
    val level: Long?,
    val rf: Int?,
    val rfReset: Int?,
    val campaignId: Long,  //TODO-xy6er удалить после https://st.yandex-team.ru/DIRECT-156065
    val maxClicksCount: Int?,
    val maxClicksPeriod: Int?,
    val maxStopsCount: Int?,
    val maxStopsPeriod: Int?
)

@Component
class AdGroupInternalAdFieldsHandler(
    ppcPropertiesSupport: PpcPropertiesSupport
) :
    AdGroupBaseHandler<AdGroupInternalFields>() {

    private val rfOptionsExportByFilterEnabledProp = ppcPropertiesSupport.get(
        PpcPropertyNames.BS_EXPORT_RF_OPTIONS_FILTER_INTERNAL_AD_GROUPS_ENABLED,
        Duration.ofMinutes(5),
    )
    private val filterByCampaignIdsProp = ppcPropertiesSupport.get(
        PpcPropertyNames.BS_EXPORT_RF_OPTIONS_FILTER_BY_CAMPAIGN_IDS,
        Duration.ofMinutes(5),
    )

    override fun resourceType() = AdGroupResourceType.INTERNAL_AD_FIELDS

    override fun loadResources(shard: Int, adGroups: Collection<ru.yandex.direct.core.entity.adgroup.model.AdGroup>):
        List<AdGroupResource<AdGroupInternalFields>> {
        return adGroups
            .asSequence()
            .filterIsInstance<InternalAdGroup>()
            .map {
                AdGroupResource(
                    adGroupId = it.id,
                    campaignId = it.campaignId,
                    AdGroupInternalFields(
                        level = it.level,
                        rf = it.rf,
                        rfReset = it.rfReset,
                        campaignId = it.campaignId,
                        maxClicksCount = it.maxClicksCount,
                        maxClicksPeriod = it.maxClicksPeriod,
                        maxStopsCount = it.maxStopsCount,
                        maxStopsPeriod = it.maxStopsPeriod
                    )
                )
            }
            .toList()
    }

    override fun fillExportObject(resource: AdGroupInternalFields, builder: AdGroup.Builder) {
        builder.apply {
            internalLevel = if (resource.level == null) {
                OptionalInternalLevel.newBuilder().build()
            } else {
                OptionalInternalLevel.newBuilder().setValue(resource.level.toInt()).build()
            }
            rfOptions = createRfOptions(
                resource.rf,
                resource.rfReset,
                resource.maxClicksCount,
                resource.maxClicksPeriod,
                resource.maxStopsCount,
                resource.maxStopsPeriod
            )
        }
    }

    private fun needExportGroupRfOptions(campaignId: Long?): Boolean {
        // смотрим надо ли фильтровать группы по cid'ам, нужно для проверки экспорта нового RF'а.
        // Удалим проперти когда убедимся, что новый RF работает: https://st.yandex-team.ru/DIRECT-156065
        if (rfOptionsExportByFilterEnabledProp.getOrDefault(true)) {
            return filterByCampaignIdsProp.getOrDefault(emptySet()).contains(campaignId)
        }
        return true
    }
}
