package ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.handler

import org.slf4j.LoggerFactory
import org.springframework.stereotype.Component
import ru.yandex.adv.direct.adgroup.AdGroup
import ru.yandex.direct.core.bsexport.repository.adgroup.resources.BsExportAdgroupMinusPhrasesRepository
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.MinusPhrasesInfo
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.AdGroupResource
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.handler.minusphrases.MinusPhrasesBsPrepareService
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.handler.minusphrases.MinusPhrasesList


@Component
class AdGroupMinusPhrasesHandler(
    private val minusPhrasesBsPrepareService: MinusPhrasesBsPrepareService,
    private val minusPhrasesRepository: BsExportAdgroupMinusPhrasesRepository,
) : AdGroupBaseHandler<MinusPhrasesList>() {
    companion object {
        private val logger = LoggerFactory.getLogger(AdGroupMinusPhrasesHandler::class.java)
    }


    override fun getAdGroupIdsToLoad(shard: Int, objects: Collection<BsExportAdGroupObject>): List<Long> {
        val minusWordsIds = objects
            .asSequence()
            .map { it.additionalInfo }
            .filterIsInstance<MinusPhrasesInfo>()
            .map { it.minusWordId }
            .toSet()

        val adGroupIdsFromMinusWords = minusPhrasesRepository.getAdGroupIdsForMinusWords(shard, minusWordsIds)
        val adGroupIdsFromObjects = objects.asSequence()
            .filter { it.adGroupId != null }
            .map { it.adGroupId!! }
        return (adGroupIdsFromMinusWords + adGroupIdsFromObjects).distinct()
    }

    override fun resourceType() = AdGroupResourceType.MINUS_PHRASES

    override fun loadResources(shard: Int, adGroups: Collection<ru.yandex.direct.core.entity.adgroup.model.AdGroup>):
        List<AdGroupResource<MinusPhrasesList>> {
        logger.info("Going to handle ${adGroups.size} adgroups")
        return minusPhrasesBsPrepareService.processAdGroupsMinusPhrases(shard, adGroups)
            .map { AdGroupResource(it.adGroupId, it.campaignId, it.minusPhrases) }
    }

    override fun fillExportObject(resource: List<String>, builder: AdGroup.Builder) {
        builder.addAllMinusPhrases(resource)
    }

    data class AdGroupIdWithCampaignId(val adGroupId: Long, val campaignId: Long)
}


