package ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.adgroup.AdGroup
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.AdGroupResource


@Component
internal class AdGroupPageGroupTagsHandler : AdGroupBaseHandler<List<String>>() {

    companion object {
        private val defaultTags = mapOf(
            AdGroupType.CPM_GEOPRODUCT to "app-metro",
            AdGroupType.CPM_YNDX_FRONTPAGE to "portal-trusted",
            AdGroupType.CONTENT_PROMOTION_VIDEO to "content-promotion-video",
            AdGroupType.CONTENT_PROMOTION to "content-promotion-collection",

            )
    }

    override fun resourceType() = AdGroupResourceType.PAGE_GROUP_TAGS

    override fun loadResources(shard: Int, adGroups: Collection<ru.yandex.direct.core.entity.adgroup.model.AdGroup>) =
        adGroups
            .map {
                AdGroupResource(adGroupId = it.id, campaignId = it.campaignId, getPageTags(it))
            }

    override fun fillExportObject(resource: List<String>, builder: AdGroup.Builder) {
        builder.addAllPageGroupTags(resource)
    }

    private fun getPageTags(adgroup: ru.yandex.direct.core.entity.adgroup.model.AdGroup): List<String> {
        return if (adgroup.pageGroupTags != null && adgroup.pageGroupTags.isNotEmpty()) adgroup.pageGroupTags
        else if (defaultTags.containsKey(adgroup.type)) listOf(defaultTags.getValue(adgroup.type)) else listOf()
    }
}
