package ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.showcondition.RelevanceMatchData
import ru.yandex.direct.core.entity.adgroup.model.AdGroup
import ru.yandex.direct.core.entity.adgroup.model.DynamicAdGroup
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.AdGroupResource
import ru.yandex.direct.logicprocessor.processors.bsexport.utils.YtRecordMappingUtils.relevanceMatchCategoriesToYt

@Component
class AdGroupRelevanceMatchDataHandler : AdGroupBaseHandler<RelevanceMatchData>() {
    override fun resourceType(): AdGroupResourceType {
        return AdGroupResourceType.RELEVANCE_MATCH_DATA
    }

    override fun loadResources(
        shard: Int,
        adGroups: Collection<AdGroup>,
    ): List<AdGroupResource<RelevanceMatchData>> {
        return adGroups
            .mapNotNull { adGroup ->
                when (adGroup) {
                    is DynamicAdGroup -> {
                        AdGroupResource(
                            adGroupId = adGroup.id,
                            campaignId = adGroup.campaignId,
                            resource = relevanceMatchCategoriesToYt(adGroup.relevanceMatchCategories)
                        )
                    }
                    else -> null
                }
            }
    }

    override fun fillExportObject(
        resource: RelevanceMatchData,
        builder: ru.yandex.adv.direct.adgroup.AdGroup.Builder,
    ) {
        builder.relevanceMatchData = resource
    }
}
