package ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.handler

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.adgroup.container.AdGroupsSelectionCriteria
import ru.yandex.direct.core.entity.adgroup.model.AdGroup
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPlacementTypes
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.common.getTargetTags
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.AdGroupResource
import ru.yandex.direct.multitype.entity.LimitOffset

@Component
class AdGroupTargetTagsHandler(
    private val adGroupRepository: AdGroupRepository,
    private val campaignTypedRepository: CampaignTypedRepository
) : AdGroupBaseHandler<List<String>>() {
    override fun getAdGroupIdsToLoad(shard: Int, objects: Collection<BsExportAdGroupObject>): List<Long> {
        val adGroupIds = objects.mapNotNull { it.adGroupId }
        val campaignIds = objects.filter { it.adGroupId == null }.map { it.campaignId!! }

        return if (campaignIds.isNotEmpty()) {
            val selectionCriteria = AdGroupsSelectionCriteria().withCampaignIds(campaignIds.toSet())
            adGroupIds + adGroupRepository.getAdGroupIdsBySelectionCriteria(shard, selectionCriteria, LimitOffset.maxLimited())
        } else adGroupIds
    }

    override fun resourceType() = AdGroupResourceType.TARGET_TAGS

    override fun loadResources(shard: Int, adGroups: Collection<AdGroup>): List<AdGroupResource<List<String>>> {
        val campaigns = campaignTypedRepository
            .getSafely(shard, adGroups.map { it.campaignId }, CampaignWithPlacementTypes::class.java)
            .associateBy { it.id }

        return adGroups
            .map {
                AdGroupResource(
                    adGroupId = it.id,
                    campaignId = it.campaignId, 
                    getTargetTags(it, campaigns[it.campaignId])?: listOf()
                )
            }
    }

    override fun fillExportObject(resource: List<String>, builder: ru.yandex.adv.direct.adgroup.AdGroup.Builder) {
        builder.addAllTargetTags(resource)
    }
}
