package ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.adgroup.AdGroup
import ru.yandex.direct.core.entity.adgroup.model.TextAdGroup
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.resource.AdGroupResource

data class AdGroupTextFields(
    val feedId: Long?,
    val fieldToUseAsName: String?,
    val fieldToUseAsBody: String?
)

@Component
class AdGroupTextFieldsHandler : AdGroupBaseHandler<AdGroupTextFields>() {

    override fun resourceType() = AdGroupResourceType.TEXT_FIELDS

    override fun loadResources(
        shard: Int,
        adGroups: Collection<ru.yandex.direct.core.entity.adgroup.model.AdGroup>
    ): List<AdGroupResource<AdGroupTextFields>> {
        return adGroups
            .asSequence()
            .filterIsInstance<TextAdGroup>()
            .map {
                AdGroupResource(
                    adGroupId = it.id,
                    campaignId = it.campaignId,
                    AdGroupTextFields(
                        feedId = it.feedId,
                        fieldToUseAsName = it.fieldToUseAsName,
                        fieldToUseAsBody = it.fieldToUseAsBody
                    )
                )
            }
            .toList()
    }

    override fun fillExportObject(resource: AdGroupTextFields, builder: AdGroup.Builder) {
        builder.apply {
            if (resource.feedId != null) {
                feedId = resource.feedId
            }
            if (resource.fieldToUseAsName != null) {
                fieldToUseAsName = resource.fieldToUseAsName
            }
            if (resource.fieldToUseAsBody != null) {
                fieldToUseAsBody = resource.fieldToUseAsBody
            }
        }
    }
}
