package ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.showcondition

import org.springframework.stereotype.Component
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupShowConditionType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.logicprocessor.processors.bsexport.common.ResourcesHandler
import ru.yandex.direct.logicprocessor.processors.bsexport.common.ResourcesHandlerDispatcher

interface AdGroupShowConditionHandler : ResourcesHandler<AdGroupShowConditionType, BsExportAdGroupShowConditionObject>

@Component
class AdGroupShowConditionHandlerDispatcher(
    resourceHandlers: List<AdGroupShowConditionHandler>
) : ResourcesHandlerDispatcher<AdGroupShowConditionType, BsExportAdGroupShowConditionObject, AdGroupShowConditionHandler>(resourceHandlers) {
    override fun getAllTypeValue() = AdGroupShowConditionType.ALL
    override fun getObjectResourceType(obj: BsExportAdGroupShowConditionObject) = obj.type
}
