package ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.showcondition

import org.slf4j.LoggerFactory
import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.ess.config.bsexport.adgroup.BsExportAdGroupShowConditionConfig
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.juggler.JugglerStatus
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.JugglerChecks
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.CheckTag
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessor
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext

@JugglerChecks(
    JugglerCheck(ttl = JugglerCheck.Duration(minutes = 5), needCheck = ProductionOnly::class,
        tags = [CheckTag.DIRECT_PRIORITY_0],
        notifications = [
            OnChangeNotification(
                recipient = [NotificationRecipient.CHAT_DIRECT_BS_TRANSPORT_YT_MONITORING],
                status = [JugglerStatus.OK, JugglerStatus.CRIT],
                method = [NotificationMethod.TELEGRAM])
        ])
)
@EssLogicProcessor(BsExportAdGroupShowConditionConfig::class)
class BsExportAdGroupShowConditionProcessor(
    essLogicProcessorContext: EssLogicProcessorContext,
    private val handlerDispatcher: AdGroupShowConditionHandlerDispatcher,
) : BaseLogicProcessor<BsExportAdGroupShowConditionObject>(essLogicProcessorContext) {

    companion object {
        private val logger = LoggerFactory.getLogger(BsExportAdGroupShowConditionProcessor::class.java)
    }

    override fun process(logicObjects: List<BsExportAdGroupShowConditionObject>) {
        logger.debug("Processing objects for (shard: {}): {}", shard, logicObjects)
        handlerDispatcher.dispatch(shard, logicObjects)
    }
}
