package ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.showcondition.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.adgroup.AdGroupShowCondition
import ru.yandex.adv.direct.adgroup.AdGroupShowConditionType.AD_GROUP_SHOW_CONDITION_TYPE_GOAL_CONTEXT
import ru.yandex.adv.direct.expression.keywords.KeywordEnum
import ru.yandex.adv.direct.expression.operations.OperationEnum
import ru.yandex.adv.direct.expression2.TargetingExpression
import ru.yandex.adv.direct.expression2.TargetingExpressionAtom
import ru.yandex.direct.core.bsexport.model.BsExportBidRetargeting
import ru.yandex.direct.core.bsexport.repository.bids.BsExportBidsRetargetingRepository
import ru.yandex.direct.core.entity.adgroup.container.AdGroupsSelectionCriteria
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType
import ru.yandex.direct.core.entity.adgroup.model.InternalAdGroup
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupShowConditionType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.showcondition.AdGroupShowConditionExportInfo
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.showcondition.AdGroupShowConditionExporter
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.showcondition.AdGroupShowConditionHandler
import ru.yandex.direct.multitype.entity.LimitOffset

@Component
class AdGroupShowConditionGoalContextHandler(
    private val adGroupRepository: AdGroupRepository,
    private val bidsRetargetingRepository: BsExportBidsRetargetingRepository,
    private val exporter: AdGroupShowConditionExporter,
) : AdGroupShowConditionHandler {

    override fun resourceType() = AdGroupShowConditionType.GOAL_CONTEXT

    override fun handle(shard: Int, objects: Collection<BsExportAdGroupShowConditionObject>) {
        if (objects.isEmpty()) return

        val showConditionInfo = loadShowConditionInfo(shard, objects)

        val preExportInfos = objects.map { obj ->
            val bid: BsExportBidRetargeting? = showConditionInfo[obj.adGroupId]
            val exportObjectBuilder = AdGroupShowCondition.newBuilder()
                .apply {
                    adGroupId = obj.adGroupId!!
                    type = AD_GROUP_SHOW_CONDITION_TYPE_GOAL_CONTEXT.number
                    if (bid != null) {
                        condition = convertToCondition(bid)
                    }
                }
            AdGroupShowConditionExportInfo(exportObjectBuilder, obj.campaignId)
        }
        exporter.export(shard, preExportInfos)
    }

    private fun loadShowConditionInfo(
        shard: Int,
        objects: Collection<BsExportAdGroupShowConditionObject>
    ): Map<Long, BsExportBidRetargeting> {
        val adGroupIds = objects.map { it.adGroupId!! }.toSet()
        val internalAdGroupIds = adGroupRepository.getAdGroupIdsBySelectionCriteria(
            shard,
            AdGroupsSelectionCriteria()
                .withAdGroupIds(adGroupIds)
                .withAdGroupTypes(AdGroupType.INTERNAL),
            LimitOffset.maxLimited())

        return bidsRetargetingRepository.getBidsByPids(shard, internalAdGroupIds)
            .map { it.adGroupId to it }
            .toMap()
    }

    private fun convertToCondition(bid: BsExportBidRetargeting): TargetingExpression {
        return TargetingExpression.newBuilder().addAnd(
            TargetingExpression.Disjunction.newBuilder().addOr(
                TargetingExpressionAtom.newBuilder()
                    .setKeyword(KeywordEnum.GoalContextId.number)
                    .setOperation(OperationEnum.MatchGoalContext.number)
                    .setValue(bid.retCondId.toString())
                    .build()
            ).build()
        ).build()
    }
}
