package ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.showcondition.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.adgroup.AdGroupShowCondition
import ru.yandex.adv.direct.adgroup.AdGroupShowConditionType.AD_GROUP_SHOW_CONDITION_TYPE_PAGE_BLOCKS
import ru.yandex.adv.direct.expression.keywords.KeywordEnum
import ru.yandex.adv.direct.expression.operations.OperationEnum
import ru.yandex.adv.direct.expression2.TargetingExpression
import ru.yandex.adv.direct.expression2.TargetingExpressionAtom
import ru.yandex.direct.core.entity.adgroup.model.PageBlock
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupShowConditionType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.showcondition.AdGroupShowConditionExportInfo
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.showcondition.AdGroupShowConditionExporter
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.showcondition.AdGroupShowConditionHandler

@Component
class AdGroupShowConditionPageBlocksHandler(
    private val adGroupRepository: AdGroupRepository,
    private val exporter: AdGroupShowConditionExporter,
) : AdGroupShowConditionHandler {

    override fun resourceType() = AdGroupShowConditionType.PAGE_BLOCKS

    override fun handle(shard: Int, objects: Collection<BsExportAdGroupShowConditionObject>) {
        if (objects.isEmpty()) return

        val showConditionInfo = loadShowConditionInfo(shard, objects)

        val preExportInfos = objects.map { obj ->
            val pageBlocks = showConditionInfo[obj.adGroupId]
            val exportObjectBuilder = AdGroupShowCondition.newBuilder()
                .apply {
                    adGroupId = obj.adGroupId!!
                    type = AD_GROUP_SHOW_CONDITION_TYPE_PAGE_BLOCKS.number
                    if (pageBlocks != null && pageBlocks.isNotEmpty()) {
                        condition = convertToCondition(pageBlocks)
                    }
                }
            AdGroupShowConditionExportInfo(exportObjectBuilder, null)
        }
        exporter.export(shard, preExportInfos)
    }

    private fun loadShowConditionInfo(shard: Int, objects: Collection<BsExportAdGroupShowConditionObject>)
    : Map<Long, List<PageBlock>> {
        val adGroupIds = objects.map { it.adGroupId }.distinct()
        return adGroupRepository.getAdGroupsPageTargetByAdGroupId(shard, adGroupIds)
    }

    private fun convertToCondition(pageBlocks: List<PageBlock>): TargetingExpression {
        return TargetingExpression.newBuilder().addAnd(
            TargetingExpression.Disjunction.newBuilder().addAllOr(
                pageBlocks.map {
                    TargetingExpressionAtom.newBuilder()
                        .setKeyword(KeywordEnum.PageIdImpId.number)
                        .setOperation(OperationEnum.Match.number)
                        .setValue("%d:%d".format(it.pageId, it.impId))
                        .build()
                }
            ).build()
        ).build()
    }
}
