package ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.showcondition.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.adgroup.AdGroupShowCondition
import ru.yandex.adv.direct.adgroup.AdGroupShowConditionType.AD_GROUP_SHOW_CONDITION_TYPE_PERFORMANCE
import ru.yandex.adv.direct.expression.keywords.KeywordEnum
import ru.yandex.adv.direct.expression.operations.OperationEnum
import ru.yandex.adv.direct.expression2.TargetingExpression
import ru.yandex.adv.direct.expression2.TargetingExpressionAtom
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupShowConditionType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.showcondition.AdGroupShowConditionExportInfo
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.showcondition.AdGroupShowConditionExporter
import ru.yandex.direct.logicprocessor.processors.bsexport.adgroup.showcondition.AdGroupShowConditionHandler

@Component
class AdGroupShowConditionPerformanceHandler(
    private val adGroupRepository: AdGroupRepository,
    private val exporter: AdGroupShowConditionExporter,
): AdGroupShowConditionHandler {

    override fun resourceType() = AdGroupShowConditionType.PERFORMANCE

    private val performanceCondition = TargetingExpression.newBuilder().addAnd(
        TargetingExpression.Disjunction.newBuilder().addOr(
            TargetingExpressionAtom.newBuilder()
                .setKeyword(KeywordEnum.Performance.number)
                .setOperation(OperationEnum.Equal.number)
                .setValue("1")
                .build()
        ).build()
    ).build()

    override fun handle(shard: Int, objects: Collection<BsExportAdGroupShowConditionObject>) {
        if (objects.isEmpty()) return

        val performanceObjects = filterPerformance(shard, objects)

        val preExportInfos = performanceObjects.map { obj ->
            val exportObjectBuilder = AdGroupShowCondition.newBuilder()
                .apply {
                    adGroupId = obj.adGroupId!!
                    type = AD_GROUP_SHOW_CONDITION_TYPE_PERFORMANCE.number
                    condition = performanceCondition
                }
            AdGroupShowConditionExportInfo(exportObjectBuilder, obj.campaignId)
        }
        exporter.export(shard, preExportInfos)
    }

    private fun filterPerformance(shard: Int, objects: Collection<BsExportAdGroupShowConditionObject>)
    : List<BsExportAdGroupShowConditionObject> {
        val adGroupIds = objects.map { it.adGroupId }.distinct()
        val adgroupTypes = adGroupRepository.getAdGroupTypesByIds(shard, adGroupIds)
        return objects.filter { adgroupTypes[it.adGroupId] == AdGroupType.PERFORMANCE }
    }
}
