package ru.yandex.direct.logicprocessor.processors.bsexport.bids

import java.util.concurrent.ConcurrentHashMap
import org.slf4j.LoggerFactory
import org.springframework.stereotype.Component
import ru.yandex.direct.ess.config.bsexport.bids.BsExportBiddableShowConditionsConfig
import ru.yandex.direct.solomon.SolomonUtils
import ru.yandex.monlib.metrics.labels.Labels
import ru.yandex.monlib.metrics.primitives.Rate

@Component
class BidRetargetingConditionMonitoring {
    private val metrics = ConcurrentHashMap<Int, Rate>()

    private val metricRegistry = run {
        val logicProcessName = BsExportBiddableShowConditionsConfig().logicProcessName
        SolomonUtils.SOLOMON_REGISTRY.subRegistry("ess_processor", logicProcessName)
    }

    fun updateRetargetingConditionBidsCount(shard: Int, bidsRetargetingProcessed: Long) {
        logger.debug("Found {} bids affected by retargeting condition changes", bidsRetargetingProcessed)
        val metric = getOrCreateMetric(shard)
        metric.add(bidsRetargetingProcessed)
    }

    private fun getOrCreateMetric(shard: Int): Rate {
        return metrics.computeIfAbsent(shard) {
            val labels = Labels.of("shard", shard.toString())
            metricRegistry.rate(BIDS_FOUND_BY_RET_COND_ID, labels)
        }
    }

    companion object {
        private const val BIDS_FOUND_BY_RET_COND_ID = "bids_found_by_ret_cond_id"
        private val logger = LoggerFactory.getLogger(BidRetargetingConditionMonitoring::class.java)
    }
}
