package ru.yandex.direct.logicprocessor.processors.bsexport.bids;

import java.util.List;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.bsexport.bids.BsExportBiddableShowConditionsConfig;
import ru.yandex.direct.ess.logicobjects.bsexport.bids.BsExportBidsObject;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_BS_EXPORT;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_0;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 20),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_0, DIRECT_BS_EXPORT},
        notifications = @OnChangeNotification(
                recipient = NotificationRecipient.CHAT_DIRECT_BS_TRANSPORT_YT_MONITORING,
                status = {JugglerStatus.OK, JugglerStatus.CRIT},
                method = NotificationMethod.TELEGRAM)
)
@EssLogicProcessor(BsExportBiddableShowConditionsConfig.class)
public class BsExportBiddableShowConditionsProcessor extends BaseLogicProcessor<BsExportBidsObject> {
    private final BsExportBiddableShowConditionsService bsExportService;

    public BsExportBiddableShowConditionsProcessor(EssLogicProcessorContext essLogicProcessorContext,
                                                   BsExportBiddableShowConditionsService bsExportService) {
        super(essLogicProcessorContext);
        this.bsExportService = bsExportService;
    }

    @Override
    public void process(List<BsExportBidsObject> logicObjects) {
        bsExportService.updateResources(getShard(), logicObjects);
    }
}
