package ru.yandex.direct.logicprocessor.processors.bsexport.campaign;

import java.util.List;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.env.NonProductionEnvironment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.ess.config.bsexport.campaign.BsExportCampaignConfig;
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.logicprocessor.common.BaseLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessor;
import ru.yandex.direct.logicprocessor.common.EssLogicProcessorContext;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_BS_EXPORT;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_0;

@JugglerCheck(
        ttl = @JugglerCheck.Duration(minutes = 5),
        needCheck = ProductionOnly.class,
        tags = {DIRECT_PRIORITY_0, DIRECT_BS_EXPORT},
        notifications = @OnChangeNotification(
                recipient = NotificationRecipient.CHAT_DIRECT_BS_TRANSPORT_YT_MONITORING,
                status = {JugglerStatus.OK, JugglerStatus.CRIT},
                method = NotificationMethod.TELEGRAM))
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 10), needCheck = NonProductionEnvironment.class)
@EssLogicProcessor(BsExportCampaignConfig.class)
public class BsExportCampaignProcessor extends BaseLogicProcessor<BsExportCampaignObject> {

    private final BsExportCampaignService bsExportCampaignService;

    public BsExportCampaignProcessor(EssLogicProcessorContext essLogicProcessorContext,
                                     BsExportCampaignService bsExportCampaignService) {
        super(essLogicProcessorContext);
        this.bsExportCampaignService = bsExportCampaignService;
    }

    @Override
    public void process(List<BsExportCampaignObject> logicObjects) {
        bsExportCampaignService.processCampaigns(getShard(), logicObjects);
    }

}
