package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.container;

import ru.yandex.adv.direct.campaign.CampaignMetatype;
import ru.yandex.adv.direct.campaign.CampaignSource;

public class CampaignCommonFields {
    private final String type;
    private final long clientId;
    private final boolean archive;
    private final boolean stop;
    private final String name;
    private final String latName;
    private final CampaignSource source;
    private final CampaignMetatype metatype;

    public CampaignCommonFields(String type, long clientId, boolean archive, boolean stop, String name,
                                String latName, CampaignSource source, CampaignMetatype metatype) {
        this.type = type;
        this.clientId = clientId;
        this.archive = archive;
        this.stop = stop;
        this.name = name;
        this.latName = latName;
        this.source = source;
        this.metatype = metatype;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getType() {
        return type;
    }

    public long getClientId() {
        return clientId;
    }

    public boolean isArchive() {
        return archive;
    }

    public boolean isStop() {
        return stop;
    }

    public String getName() {
        return name;
    }

    public String getLatName() {
        return latName;
    }

    public CampaignSource getSource() {
        return source;
    }

    public CampaignMetatype getMetatype() {
        return metatype;
    }

    @Override
    public String toString() {
        return "CampaignCommonFields{" +
                "type='" + type + '\'' +
                ", clientId=" + clientId +
                ", archive=" + archive +
                ", stop=" + stop +
                ", name='" + name + '\'' +
                ", latName='" + latName + '\'' +
                ", source='" + source + '\'' +
                ", metatype='" + metatype + '\'' +
                '}';
    }

    public static class Builder {
        private String type;
        private long clientId;
        private boolean archive;
        private boolean stop;
        private String name;
        private String latName;
        private CampaignSource source;
        private CampaignMetatype metatype;

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withClientId(long clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withArchive(boolean archive) {
            this.archive = archive;
            return this;
        }

        public Builder withStop(boolean stop) {
            this.stop = stop;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withLatName(String latName) {
            this.latName = latName;
            return this;
        }

        public Builder withSource(CampaignSource source) {
            this.source = source;
            return this;
        }

        public Builder withMetatype(CampaignMetatype metatype) {
            this.metatype = metatype;
            return this;
        }

        public CampaignCommonFields build() {
            return new CampaignCommonFields(type, clientId, archive, stop, name, latName, source, metatype);
        }
    }
}
