package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.campaign.Campaign
import ru.yandex.direct.core.entity.campaign.model.CampaignWithAllowedOnAdultContent
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType

typealias AllowedOnAdultContent = Boolean

@Component
open class CampaignAllowedOnAdultContentHandler
    : TypedCampaignResourceHandler<AllowedOnAdultContent, CampaignWithAllowedOnAdultContent>() {

    override val resourceType = CampaignResourceType.CAMPAIGN_ALLOWED_ON_ADULT_CONTENT

    override val campaignToLoad = CampaignWithAllowedOnAdultContent::class.java

    override fun mapCampaignToResource(campaign: CampaignWithAllowedOnAdultContent): AllowedOnAdultContent =
        campaign.isAllowedOnAdultContent

    override fun fillExportObject(resource: AllowedOnAdultContent, builder: Campaign.Builder) {
        builder.allowedOnAdultContent = resource
    }
}
