package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.handler

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign
import ru.yandex.direct.core.entity.user.repository.UserRepository
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.campaign.container.CampaignWithBuilder

typealias ClientChiefRepLogin = String

@Component
class CampaignClientChiefRepLoginHandler(
    private val userRepository: UserRepository,
) : ICampaignResourceHandler<ClientChiefRepLogin> {

    override val resourceType = CampaignResourceType.CLIENT_CHIEF_REP_LOGIN

    override fun handle(shard: Int, campaigns: Map<Long, CampaignWithBuilder>) {
        val chiefUidByCid = campaigns.values
            .mapNotNull { it.campaign as CommonCampaign }
            .map { it.id to it.uid }
            .toMap()
        val loginByUid = userRepository.getLoginsByUids(chiefUidByCid.values)

        for ((cid, campaignWithBuilder) in campaigns) {
            val uid = chiefUidByCid.getOrDefault(cid, 0L)
            val login = loginByUid.getOrDefault(uid, "")
            campaignWithBuilder.builder.clientChiefRepLogin = login
        }
    }
}
