package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.handler

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject

@Component
open class CampaignDeleteHandler(private val campaignTypedRepository: CampaignTypedRepository) {
    fun getDeletedCampaignIds(shard: Int, objects: Collection<BsExportCampaignObject>): Set<Long> {
        val cids = objects.mapNotNullTo(hashSetOf()) { it.cid }
        val existingCids = campaignTypedRepository.getSafely(shard, cids, CommonCampaign::class.java)
            .mapTo(hashSetOf()) { it.id }

        return cids - existingCids
    }
}
