package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.campaign.Campaign
import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter.meaningfulGoalsFromDb
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMeaningfulGoalsWithRequiredFields
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.campaign.container.MeaningfulGoalsWithCurrency
import ru.yandex.direct.logicprocessor.processors.bsexport.utils.MeaningfulGoalConverter
import ru.yandex.direct.utils.CommonUtils.nvl
import ru.yandex.direct.utils.HashingUtils.getMd5HalfHashUtf8
import ru.yandex.adv.direct.campaign.MeaningfulGoal as MeaningfulGoalProto

@Component
class CampaignMeaningfulGoalsHandler
    : TypedCampaignResourceHandler<MeaningfulGoalsWithCurrency, CampaignWithMeaningfulGoalsWithRequiredFields>() {

    override val resourceType: CampaignResourceType = CampaignResourceType.CAMPAIGN_MEANINGFUL_GOALS

    override val campaignToLoad = CampaignWithMeaningfulGoalsWithRequiredFields::class.java

    override fun mapCampaignToResource(campaign: CampaignWithMeaningfulGoalsWithRequiredFields) =
            MeaningfulGoalsWithCurrency(campaign.rawMeaningfulGoals, campaign.currency)

    override fun fillExportObject(resource: MeaningfulGoalsWithCurrency, builder: Campaign.Builder) {
        builder.meaningfulGoalsBuilder
                .addAllMeaningfulGoal(meaningfulGoalsToProto(resource))

        //md5Half помещается в 64 бита->конвертим в long(он тоже хранится в 64 битах) ->
        //протобуф конвертит отрицательные значения в положительные корректно uint64
        builder.meaningfulGoalsHash =
                getMd5HalfHashUtf8(nvl(resource.rawMeaningfulGoals, "")).toLong()
    }

    private fun meaningfulGoalsToProto(
            meaningfulGoals: MeaningfulGoalsWithCurrency
    ): List<MeaningfulGoalProto> {
        return nvl(meaningfulGoalsFromDb(meaningfulGoals.rawMeaningfulGoals), emptyList())
                .map { MeaningfulGoalConverter.meaningfulGoalToProto(meaningfulGoals.currencyCode, it) }
    }
}
