package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.campaign.Campaign
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMetrikaCounters
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType

@Component
class CampaignMetrikaCounterIdsHandler : TypedCampaignResourceHandler<List<Long>, CampaignWithMetrikaCounters>() {
    override val resourceType = CampaignResourceType.METRIKA_COUNTER_IDS

    override val campaignToLoad = CampaignWithMetrikaCounters::class.java

    override fun mapCampaignToResource(campaign: CampaignWithMetrikaCounters): List<Long> =
        campaign.metrikaCounters ?: listOf()

    override fun fillExportObject(resource: List<Long>, builder: Campaign.Builder) {
        builder.metrikaCounterIdsBuilder.addAllValues(resource)
    }
}
