package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.campaign.Campaign
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMinusKeywords
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType

private typealias MinusPhrases = List<String>

@Component
open class CampaignMinusPhrasesHandler
    : TypedCampaignResourceHandler<MinusPhrases, CampaignWithMinusKeywords>() {

    override val resourceType = CampaignResourceType.CAMPAIGN_MINUS_PHRASES

    override val campaignToLoad = CampaignWithMinusKeywords::class.java

    override fun mapCampaignToResource(campaign: CampaignWithMinusKeywords): MinusPhrases =
        campaign.minusKeywords

    override fun fillExportObject(resource: List<String>, builder: Campaign.Builder) {
        builder.minusPhrasesBuilder.addAllValues(resource)
    }
}
