package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.campaign.Campaign
import ru.yandex.adv.direct.campaign.OptionalMultipliers
import ru.yandex.direct.core.bsexport.repository.BsExportMultipliersRepository
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.MultiplierInfo
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.RetargetingConditionInfo
import ru.yandex.direct.logicprocessor.processors.bsexport.campaign.container.CampaignWithBuilder
import ru.yandex.direct.logicprocessor.processors.bsexport.multipliers.BsExportMultipliersService

@Component
class CampaignMultipliersHandler(
    private val bsExportMultipliersRepository: BsExportMultipliersRepository,
    private val bsExportMultipliersService: BsExportMultipliersService,
) : ICampaignResourceHandler<OptionalMultipliers> {

    override val resourceType = CampaignResourceType.MULTIPLIERS

    override fun getCampaignsIdsToLoad(shard: Int, objects: Collection<BsExportCampaignObject>): Collection<Long> {
        val retargetingIds = objects
            .mapNotNull {
                (it.additionalInfo as? RetargetingConditionInfo)?.retargetingConditionId
                    ?: it.retargetingConditionId
            }
        val multipliersWithRetargetingIds = bsExportMultipliersRepository
            .getMultiplierIdsByRetargetingConditionIds(shard, retargetingIds)
            .toSet()

        val multiplierIds = multipliersWithRetargetingIds + objects
            .mapNotNull {
                (it.additionalInfo as? MultiplierInfo)?.hierarchicalMultiplierId
                    ?: it.hierarchicalMultiplierId
            }
        val multiplierCampaignIds = bsExportMultipliersRepository
            .getCampaignIdsByHierarchicalMultiplierIds(shard, multiplierIds)
            .toSet()

        return multiplierCampaignIds + objects.mapNotNull(BsExportCampaignObject::getCid)
    }

    override fun handle(shard: Int, campaigns: Map<Long, CampaignWithBuilder>) {
        val multipliers = bsExportMultipliersService
            .getCampaignMultipliers(shard, campaigns.keys)

        for ((cid, campaignWithBuilder) in campaigns) {
            val resource = OptionalMultipliers.newBuilder()
                .addAllMultiplier(multipliers[cid] ?: emptyList())
                .build()
            fillExportObject(resource, campaignWithBuilder.builder)
        }
    }

    private fun fillExportObject(resource: OptionalMultipliers, builder: Campaign.Builder) {
        builder.multipliers = resource
    }
}
