package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.campaign.Campaign
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign
import ru.yandex.direct.core.entity.campaign.model.InternalCampaign
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.common.createRfOptions
import java.time.Duration

data class CampaignRfFields(
    val rf: Int?,
    val rfReset: Int?,
    val clientId: Long,  //TODO-xy6er удалить после https://st.yandex-team.ru/DIRECT-156065
    val maxClicksCount: Int?,
    val maxClicksPeriod: Int?,
    val maxStopsCount: Int?,
    val maxStopsPeriod: Int?
)

/**
 * Экспорт RfOptions (новый RF). Сейчас используется только для кампаний внутренней рекламы, но в будущем легко
 * можно поддержать для остальных типов кампаний у которых есть RF
 */
@Component
class CampaignRfOptionsHandler(
    ppcPropertiesSupport: PpcPropertiesSupport,
) : TypedCampaignResourceHandler<CampaignRfFields, InternalCampaign>() {

    private val rfOptionsExportByFilterEnabledProp = ppcPropertiesSupport.get(
        PpcPropertyNames.BS_EXPORT_RF_OPTIONS_FILTER_INTERNAL_CAMPAIGN_ENABLED,
        Duration.ofMinutes(5),
    )
    private val filterByClientIdsProp = ppcPropertiesSupport.get(
        PpcPropertyNames.BS_EXPORT_RF_OPTIONS_FILTER_BY_CLIENT_IDS,
        Duration.ofMinutes(5),
    )

    override val resourceType = CampaignResourceType.CAMPAIGN_RF_OPTIONS

    override val campaignToLoad = InternalCampaign::class.java

    override fun mapCampaignToResource(campaign: InternalCampaign): CampaignRfFields {
        return CampaignRfFields(
            rf = campaign.impressionRateCount,
            rfReset = campaign.impressionRateIntervalDays,
            clientId = (campaign as CommonCampaign).clientId,
            maxClicksCount = campaign.maxClicksCount,
            maxClicksPeriod = campaign.maxClicksPeriod,
            maxStopsCount = campaign.maxStopsCount,
            maxStopsPeriod = campaign.maxStopsPeriod
        )
    }

    override fun fillExportObject(resource: CampaignRfFields, builder: Campaign.Builder) {
        builder.apply {
            rfOptions = createRfOptions(
                resource.rf,
                resource.rfReset,
                resource.maxClicksCount,
                resource.maxClicksPeriod,
                resource.maxStopsCount,
                resource.maxStopsPeriod
            )
        }
    }

    private fun needExportCampaignRfOptions(clientId: Long?): Boolean {
        if (rfOptionsExportByFilterEnabledProp.getOrDefault(true)) {
            return filterByClientIdsProp.getOrDefault(emptySet()).contains(clientId)
        }
        return true
    }
}
