package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.campaign.Campaign
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.CampaignWithStrategy
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.campaign.container.CampaignStrategy
import ru.yandex.direct.logicprocessor.processors.bsexport.campaign.utils.DisallowedTargetTypesCalculator

@Component
open class CampaignStrategyHandler(
    private val disallowedTargetTypesCalculator: DisallowedTargetTypesCalculator,
) : TypedCampaignResourceHandler<CampaignStrategy, CampaignWithStrategy>() {

    override val resourceType = CampaignResourceType.CAMPAIGN_STRATEGY

    override val campaignToLoad = CampaignWithStrategy::class.java

    override fun mapCampaignToResource(campaign: CampaignWithStrategy) : CampaignStrategy {
        var strategyId : Long? = null

        if (campaign is CampaignWithPackageStrategy) {
            strategyId = campaign.strategyId
        }

        return CampaignStrategy(strategyId, disallowedTargetTypesCalculator.calculate(campaign))
    }

    override fun fillExportObject(resource: CampaignStrategy, builder: Campaign.Builder) {
        builder.disallowedTargetTypesBuilder
            .addAllValues(resource.disallowedTargetTypes)
        builder.apply {
            if (resource.id != null) {
                strategyId = resource.id
            }
        }

    }
}
