package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.handler

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.campaign.container.CampaignWithBuilder

typealias WidgetPartnerId = Long

@Component
class CampaignWidgetPartnerIdHandler(
    private val campaignRepository: CampaignRepository,
) : ICampaignResourceHandler<WidgetPartnerId> {

    override val resourceType = CampaignResourceType.WIDGET_PARTNER_ID

    override fun handle(shard: Int, campaigns: Map<Long, CampaignWithBuilder>) {
        val widgetPartnerIds = campaignRepository.getWidgetPartnerIdsByCids(shard, campaigns.keys)
        for ((cid, campaignWithBuilder) in campaigns) {
            widgetPartnerIds[cid]?.let { campaignWithBuilder.builder.setWidgetPartnerId(it) }
        }
    }
}
