package ru.yandex.direct.logicprocessor.processors.bsexport.campaign.handler

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.campaign.Campaign
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBrandLift
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType

@Component
class CampaignWithBrandLiftHandler : TypedCampaignResourceHandler<Boolean, CampaignWithBrandLift>() {
    override val resourceType = CampaignResourceType.IS_CPM_GLOBAL_AB_SEGMENT

    override val campaignToLoad = CampaignWithBrandLift::class.java

    override fun mapCampaignToResource(campaign: CampaignWithBrandLift): Boolean =
        campaign.isCpmGlobalAbSegment?:false && !campaign.isSearchLiftEnabled && campaign.brandSurveyId == null

    override fun fillExportObject(resource: Boolean, builder: Campaign.Builder) {
        builder.isCpmGlobalAbSegment = resource
    }
}
